import random
from itertools import count
import pandas as pd
import matplotlib.pyplot as plt


from matplotlib.animation import FuncAnimation

# graph being plotted from a csv that is constantly being updated
# from an api, from a sensor, whatever

plt.style.use("fivethirtyeight")

x_vals = []
y_vals = []

def animate(i):
    #read from csv
    data = pd.read_csv('data.csv')
    x = data["x_value"]
    y1 = data["total_1"]
    y2 = data["total_2"]
    
    # we need to clear the older line, so they are not stacked together
    # clear the axis, clears the legend also
    plt.cla()
    plt.plot(x, y1, label="Channel 1")
    plt.plot(x, y2, label="Channel 2")
    # always fix the location when data is updated live
    plt.legend(loc="upper left")
    # with each update make it tight
    plt.tight_layout()
    
# animate the function
# matplotlib is doing this automaticali
ani = FuncAnimation(plt.gcf(), animate, interval=1000)
    


plt.show()
